#include "ScnGames.h"

#include <vector>
#include <map>
#include "xmedia.h"

using namespace std;

//ContentItem * ListItems;
ContentItems * items;
int ToDisplay = 0;
wstring GenreDisp;
ContentItem * CurentGame = NULL;
bool ShowOnlyFavs = false;
bool ShowFavs = false;
bool ShowRecent = false;
int gameindex = 0;
int favindex = 0;

bool fullscreen = false;

HRESULT CScnGames::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	xmvPlayer = NULL;
  	//char temp[1024];
    // Retrieve controls for later use.
    GetChildById( L"GameList", &m_list );
    GetChildById( L"TitleText", &m_title );
    GetChildById( L"TitleIcon", &m_titleicon );//MATTIE: adding title icon
    GetChildById( L"Genre", &m_genre );
    GetChildById( L"Cover", &m_cover );
    GetChildById( L"ScreenShot1", &m_ss1 );
    GetChildById( L"ScreenShot2", &m_ss2 );
    GetChildById( L"DescText", &m_desc );
   // GetChildById( L"TxtFreeMem", &m_freemem );
    GetChildById( L"GenreButton", &m_genrebutton );
    GetChildById( L"XButton", &m_xbutton );
    GetChildById( L"ToggleFav", &m_lb );
    GetChildById( L"ShowFav", &m_rb );
    GetChildById( L"GameTitle", &m_gametitle );
    GetChildById( L"Video", &m_video );
    GetChildById( L"VideoBack", &m_videoback );
    GetChildById( L"Background", &m_background );
    GetChildById( L"Date", &m_date );
    GetChildById( L"Time", &m_time );
    GetChildById( L"DateTime", &m_datetime );
	GetChildById( L"BackButton", &m_BackBtn );
	
	GetChildById( L"BackgroundPanel", &m_BP);
    GetChildById( L"XuiControl1", &m_BP2);

	GetChildById( L"FullScreenPreview", &m_fullpreview );
	GetChildById( L"FullScreenPreviewBG", &m_fullpreviewbg );
	GetChildById( L"ToggleFullScreen", &m_fullscreenbutton );

	m_fullpreviewbg.SetShow(FALSE);
	m_fullpreview.SetShow(FALSE);
	m_fullscreenbutton.SetShow(FALSE);

	
	if (ParentalControl == 1)
	{
		m_BackBtn.SetEnable(false);
		m_BackBtn.SetShow(false);
	} else {
		m_BackBtn.SetEnable(true);
		m_BackBtn.SetShow(true);
	}

	m_videoback.SetShow(FALSE);
	m_video.SetShow(FALSE);
	m_background.SetShow(FALSE);

	wstring title;
	wstring titleicon; //MATTIE: add title icon as well
	if (ToDisplay == 0)
	{
		title = L"XBox Live Arcade Games";
		titleicon = L"IconXboxLiveArcadeGames.png";
	}
	if (ToDisplay == 1)
	{
		title = L"XBox 360 Games";
		titleicon = L"IconXBox360Games.png";
	}
	if (ToDisplay == 2)
	{
		title = L"XBox Games";
		titleicon = L"IconXboxGames.png";
	}
	if (ToDisplay == 3)
	{
		title = L"Homebrew";
		titleicon = L"IconHomeBrew.png";
	}
	if (ToDisplay == 4)
	{
		title = L"Emulators";
		titleicon = L"IconEmulators.png";
	}
	m_rb.SetEnable(true);
	m_rb.SetShow(true);
	if (ShowFavs)
	{
		title = L"Favorite Games";
		titleicon = L"IconFavouriteGames.png";
		m_rb.SetShow(false);
		m_rb.SetEnable(false);
	}
	if (ShowRecent)
	{
		title = L"Recently Played Games";
		titleicon = L"IconRecentlyPlayedGames.png";
	}
	
	if (GenreDisp.size() > 0)
	{
		title.append(L" - ");
		title.append(GenreDisp);
	}

	m_title.SetText(title.c_str());
	m_titleicon.SetImagePath(titleicon.c_str()); //MATTIE: set the title icon

	//m_freemem.SetText(L"TESTING");

	ListSel(0);

	if (ToDisplay < 3)
	{
		m_genrebutton.SetShow(TRUE);
		//m_genrebutton.SetText(L"Genres");
	} else {
		m_genrebutton.SetShow(FALSE);
		//m_genrebutton.SetText(L"");
	}

	if (ShowOnlyFavs)
	{
		m_rb.SetText(L"All Games");
	} else {
		m_rb.SetText(L"Only Favs");
	}

	SetClock(m_date,m_time,m_datetime);
	SetTimer(TM_CLOCK,1000);

	return S_OK;
}


//----------------------------------------------------------------------------------
// Handler for the button press message.
//----------------------------------------------------------------------------------
HRESULT CScnGames::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
    if ( hObjPressed == m_list )
    {
        int nIndex = m_list.GetCurSel();

		ContentItem * item = items->pItems[nIndex];
		cl.LaunchGame(item);
		bHandled = true;
    } else if ( hObjPressed == m_lb )
	{
		int Sel = m_list.GetCurSel();
		if (Sel < items->nItems && Sel!=-1)
		{
			items->pItems[Sel]->Favourite = !items->pItems[Sel]->Favourite;

			if (items->pItems[Sel]->Favourite)
			{
				m_lb.SetText(L"Del Fav");
			} else {
				m_lb.SetText(L"Add Fav");
			}
			DoSaveSettings();
		}
		bHandled = true;
		
	} else if ( hObjPressed == m_rb )
	{
		if (ShowOnlyFavs)
		{
			favindex = m_list.GetCurSel();
		} else {
			gameindex = m_list.GetCurSel();
		}

		ShowOnlyFavs = !ShowOnlyFavs;
		//DebugMsg("Fav Show %d",ShowOnlyFavs);
		XUIMessage xuiMsg;
		XuiMessage(&xuiMsg,XM_LIST_REFRESH);
		XuiSendMessage( m_list, &xuiMsg );

		if (ShowOnlyFavs)
		{
			if (favindex >= 0 && favindex <= items->nItems)
			{
				m_list.SetCurSel(favindex);
				m_list.SetTopItem(favindex);
			} else {
				m_list.SetCurSel(0);
				m_list.SetTopItem(0);
			}
		} else {
			if (gameindex >= 0 && gameindex <= items->nItems)
			{
				m_list.SetCurSel(gameindex);
				m_list.SetTopItem(gameindex);
			} else {
				m_list.SetCurSel(0);
				m_list.SetTopItem(0);
			}
		}
		if (ShowOnlyFavs)
		{
			m_rb.SetText(L"All Games");
		} else {
			m_rb.SetText(L"Only Favs");
		}
		
		bHandled = true;
	} else if ( hObjPressed == m_fullscreenbutton )
	{
		if (!fullscreen)
		{
			ViewFullScreen();
		}
		else
		{
			KillFullScreen();
		}
		bHandled = true;
	}

    return S_OK;
}
#define MB	(1024*1024)

HRESULT CScnGames::OnNotifySelChanged( HXUIOBJ hObjSource, XUINotifySelChanged* pNotifySelChangedData, BOOL& bHandled )
{
    MEMORYSTATUS stat;
//    CHAR strOut[1024], *pstrOut;

    // Get the memory status.
    GlobalMemoryStatus( &stat );

    // Setup the output string.
   // pstrOut = strOut;
  //  AddStr( "%4u free MB\n", stat.dwAvailPhys / MB );

	//wstring temp = strtowstr(strOut);

	//m_freemem.SetText(temp.c_str());

	if( hObjSource == m_list )
    {
        int curSel = m_list.GetCurSel();

		ListSel(curSel);

		if (items->pItems[curSel]->Favourite)
		{
			m_lb.SetText(L"Del Fav");
		} else {
			m_lb.SetText(L"Add Fav");
		}

		bHandled = TRUE;
    }

    return S_OK;
}

HRESULT CScnGames::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
	if ( pTimer->nId >= TM_LOADTITLE && pTimer->nId <= TM_LOADBACK)
		KillLoadingTimers();

    // which timer is it?
    switch( pTimer->nId )
    {
    case TM_CLOCK:
		SetClock(m_date,m_time,m_datetime);
		break;
	// Load title shot
    case TM_LOADTITLE:
		{
			int curSel = m_list.GetCurSel();

			if (curSel >= items->nItems)
				return S_OK;

			ContentItem * item = items->pItems[curSel];

			if (item->i_BoxArt)
			{
				//DebugMsg("Setting boxart to %s",item->boxart.c_str());
				m_cover.SetImagePath(item->boxart.c_str());
			} else {
				m_cover.SetImagePath(L"file://game:/media/boxart.png");
			}

			SetTimer(TM_LOADPREVIEW,10);
			break;
		}

		// Load preview video
     case TM_LOADPREVIEW:
		if (UsePreviews)
		{
			int curSel = m_list.GetCurSel();

			if (curSel >= items->nItems)
				return S_OK;

			ContentItem * item = items->pItems[curSel];

			wstring preview = datapath + L"artwork\\" + item->imagefolder + L"\\preview.wmv";
			if (FileExists(preview))
			{
				m_fullscreenbutton.SetShow(TRUE);

				m_video.SetShow(TRUE);
				m_videoback.SetShow(TRUE);

				if (xmvPlayer)
				{
					xmvPlayer->Release();
					xmvPlayer = NULL;
				}

				XMediaCreateXmvPlayerFromFile(pDevice,wstrtostr(preview).c_str(),&xmvPlayer);
				m_video.SetPlayer(xmvPlayer);

				SetTimer(TM_LOADSS1,10);
				break;
			}
			// if no preview video go straight to loading ss1
		}
	// Load ss1
    case TM_LOADSS1:
		{
			int curSel = m_list.GetCurSel();

			if (curSel >= items->nItems)
				return S_OK;

			ContentItem * item = items->pItems[curSel];

			if (item->i_SSCount > 0)
			{		
				wstring ss1 = datapath_x + L"artwork/" + item->imagefolder + L"/ss-1.jpg";
				//DebugMsg("Using ss1 %s",ss1.c_str());
				m_ss1.SetImagePath(ss1.c_str());
			} else {
				m_ss1.SetImagePath(L"file://game:/media/noss.png");
			}


			SetTimer(TM_LOADSS2,10);

		break;
		}
	// Load ss2
    case TM_LOADSS2:
		{
			int curSel = m_list.GetCurSel();

			if (curSel >= items->nItems)
				return S_OK;

			ContentItem * item = items->pItems[curSel];

			if (item->i_SSCount > 1)
			{		
				wstring ss2 = datapath_x + L"artwork/" + item->imagefolder + L"/ss-2.jpg";
				//DebugMsg("Using ss2 %s",ss2.c_str());
				m_ss2.SetImagePath(ss2.c_str());
			} else {
				m_ss2.SetImagePath(L"file://game:/media/noss.png");
			}
			SetTimer(TM_LOADBACK,10);
		break;
		}
	// Load ss2
    case TM_LOADBACK:
		if (UseBackgrounds) 
		{
			int curSel = m_list.GetCurSel();

			if (curSel >= items->nItems)
				return S_OK;

			ContentItem * item = items->pItems[curSel];

			wstring background = datapath + L"artwork\\" + item->imagefolder + L"\\background.jpg";
			if (FileExists(background))
			{
				wstring background_x = datapath_x + L"artwork/" + item->imagefolder + L"/background.jpg";
				m_background.SetImagePath(background_x.c_str());
				m_background.SetShow(TRUE);
				if(SemiTransparentBackground)
				{
					m_BP.SetOpacity(0.40);
					m_BP2.SetOpacity(0.40);
				}
			}
			else
			{
				if(SemiTransparentBackground)
				{
					m_BP.SetOpacity(1);
					m_BP2.SetOpacity(1);
				}
			}
		break;
		}
    }
    
    bHandled = TRUE;
    
    return( S_OK );
}

void CScnGames::KillLoadingTimers()
{
	KillTimer(TM_LOADTITLE);
	KillTimer(TM_LOADPREVIEW);
	KillTimer(TM_LOADBACK);
	KillTimer(TM_LOADSS1);
	KillTimer(TM_LOADSS2);
}

void CScnGames::ListSel(int curSel)
{
	if (curSel >= items->nItems)
		return;

	KillLoadingTimers();

	ContentItem * item = items->pItems[curSel];
	CurentGame = item;

	m_desc.SetText(item->desc.c_str());
	m_gametitle.SetText(item->title.c_str());

	m_cover.SetImagePath(L"");
	m_ss1.SetImagePath(L"");
	m_ss2.SetImagePath(L"");
	m_background.SetShow(FALSE);


	wstring genre;

	vector<wstring>::iterator itr;
	for (itr = item->genres.begin() ; itr != item->genres.end() ; itr++)
	{
		genre.append(*itr);
		genre.append(L" / ");
	}
	genre = genre.substr(0,genre.size() - 3);
	m_genre.SetText(genre.c_str());

	m_video.Pause(TRUE);
	m_video.SetShow(FALSE);
	m_videoback.SetShow(FALSE);

	SetTimer(TM_LOADTITLE,100);
}

HRESULT CScnGames::OnDestroy()
{
	if (xmvPlayer)
	{
		xmvPlayer->Release();
		xmvPlayer = NULL;
	}

	return S_OK;
}

HRESULT CGamesList::OnInit(XUIMessageInit *pInitData, BOOL& bHandled)
{
	//DebugMsg("CGamesList::OnInit - %d, %s",ToDisplay,wstrtostr(GenreDisp).c_str());
	if (ShowFavs)
	{
 		items = cl.GetItems(-1,GenreDisp,true);
	} else if (ShowRecent)
	{
 		items = cl.GetItems(-1,GenreDisp,false,true);
	} else {
 		items = cl.GetItems(ToDisplay,GenreDisp,ShowOnlyFavs);
	}
	InsertItems( 0, items->nItems );
	SetCurSel( 0 );
	return S_OK;
}
    
// Gets called every frame
HRESULT CGamesList::OnGetSourceDataText(XUIMessageGetSourceText *pGetSourceTextData, BOOL& bHandled)
{
	if( ( 1 == pGetSourceTextData->iData ) && ( ( pGetSourceTextData->bItemData ) ) ) {
		pGetSourceTextData->szText = 
			items->pItems[pGetSourceTextData->iItem]->title.c_str();
		bHandled = TRUE;
	}
	if( ( 2 == pGetSourceTextData->iData ) && ( ( pGetSourceTextData->bItemData ) ) ) {
		pGetSourceTextData->szText = 
			items->pItems[pGetSourceTextData->iItem]->manuf.c_str();
		bHandled = TRUE;
	}
	return S_OK;
}
    
HRESULT CGamesList::OnGetItemCountAll(XUIMessageGetItemCount *pGetItemCountData, BOOL& bHandled)
{
	pGetItemCountData->cItems = items->nItems;
	bHandled = TRUE;
	return S_OK;
}

HRESULT CGamesList::OnGetSourceDataImage(XUIMessageGetSourceImage *pGetSourceImageData, BOOL& bHandled)
{
	//DebugMsg("OnGetSourceDataImage : %d, %d",pGetSourceImageData->iData,pGetSourceImageData->bItemData);
	if( ( 0 == pGetSourceImageData->iData ) && ( pGetSourceImageData->bItemData ) ) {
		if (items->pItems[pGetSourceImageData->iItem]->icon.size() > 0)
		{
			pGetSourceImageData->szPath = 
				items->pItems[pGetSourceImageData->iItem]->icon.c_str();
		} else {
			pGetSourceImageData->szPath = L"noicon.png";

		}
		bHandled = TRUE;
	}
	if( ( 1 == pGetSourceImageData->iData ) && ( pGetSourceImageData->bItemData ) ) {

		//DebugMsg("Image 5 - %d",pGetSourceImageData->iItem);
		if (items->pItems[pGetSourceImageData->iItem]->boxart.size() > 0)
		{
			pGetSourceImageData->szPath = 
				items->pItems[pGetSourceImageData->iItem]->boxart.c_str();
		} else {
			pGetSourceImageData->szPath = L"boxart.png";
		}
		bHandled = TRUE;
	}
	if( ( 5 == pGetSourceImageData->iData ) && ( pGetSourceImageData->bItemData ) ) {

		//DebugMsg("Image 5 - %d",pGetSourceImageData->iItem);
		if (items->pItems[pGetSourceImageData->iItem]->Favourite)
		{
			pGetSourceImageData->szPath = L"ylwstar.png";
		} else {
			pGetSourceImageData->szPath = L"";
		}
		bHandled = TRUE;
	}
	return S_OK;
}

HRESULT CGamesList::OnListRefresh(BOOL& bHandled )
{
	DeleteItems( 0, items->nItems);
	items = cl.GetItems(ToDisplay,GenreDisp,ShowOnlyFavs);
	InsertItems( 0, items->nItems );
	SetCurSel(0);

    return( S_OK );
}


void CScnGames::ViewFullScreen()
{
		int curSel = m_list.GetCurSel();

		if (curSel >= items->nItems)
		return;

		ContentItem * item = items->pItems[curSel];

		wstring preview = datapath + L"artwork\\" + item->imagefolder + L"\\preview.wmv";

		if (FileExists(preview))
		{

			m_fullpreviewbg.SetShow(TRUE);
			m_fullpreview.SetShow(TRUE);
			m_video.Pause(TRUE);


			if (xmvPlayer)
			{
				xmvPlayer->Release();
				xmvPlayer = NULL;
			}

			XMediaCreateXmvPlayerFromFile(pDevice,wstrtostr(preview).c_str(),&xmvPlayer);

			m_fullpreview.SetPlayer(xmvPlayer);
		
			fullscreen = true;
		}
}

void CScnGames::KillFullScreen()
{
	m_fullpreviewbg.SetShow(FALSE);
	m_fullpreview.SetShow(FALSE);
	m_fullpreview.Pause(TRUE);

	SetTimer(TM_LOADPREVIEW,10);

	fullscreen = false;
}
